<?php defined('SYSPATH') or die('No direct script access.');

/**
 * Available params:
 *
 * For access
 * php index.php --task=indexer:optimize --type=access
 *
 * For history
 * php index.php --task=indexer:optimize --type=history
 *
 * For logpost
 * php index.php --task=indexer:optimize --type=logpost
 */
class Task_Indexer_Optimize extends Minion_Task {

    protected $_options = array(
        'type'  => NULL
    );

    protected function _execute(array $params){
        if(!in_array($params['type'], ['access', 'logpost', 'history'])){
            Minion_CLI::write('Input valid type, see --help');
            exit;
        }

        $indexes = $this->scanDir('/home/storage_ex/'.$params['type']);

        foreach($indexes as $i){
            $info = $this->getConfigByDB($i);

            foreach($info as $c){
                $c = $this->updPath($c, $params['type']);
                $db_limit = DB::select('id')
                    ->from('counter')
                    ->where('name', '=', $c['name'])
                    ->limit(1)
                    ->execute()
                    ->as_array(null, 'id');

                if(count($this->scanDir($c['path'])) > 12 && intval($db_limit[0]) == $c['limit']){
                    $db_conf = Kohana::$config->load('database');
                    $port = $db_conf[$params['type'].'_'.$c['database']]['connection']['port'];

                    /* FLUSH RAM chunk */
                    exec('mysql -e "FLUSH RAMCHUNK '.$c['name'].'" -h127.0.0.1 -P'.$port);

                    /* OPTIMIZE */
                    exec('mysql -e "OPTIMIZE INDEX '.$c['name'].'" -h127.0.0.1 -P'.$port);

                    do{
                        sleep(5);
                    }while(count($this->scanDir($c['path'])) > 13);
                }else{
                    sleep(3);
                }
            }
        }
    }

    private function scanDir($path){
        $trash = ['bin', 'pid', '.', '..'];
        $files = scandir($path);
        foreach($trash as $t){
            unset($files[array_search($t, $files)]);
        }
        return $files;
    }

    private function updPath($params, $type){
        preg_match('#sphinx\_(\d+\_\d+)#', $params['database'], $path_part_1);
        preg_match('#\d?(\d{1,2})\_\d+#', $params['name'], $tmp_path_part_2);
        $path_part_2 = intval($tmp_path_part_2[1]);
        $params['path'] = '/home/storage_ex/'.$type.'/'.$path_part_1[1].'/'.$path_part_2;
        return $params;
    }

    public static function getConfigByDB($db){
        $array = array();
        $config = Kohana::$config->load('config')->as_array();
        foreach($config as $k => $c){
            foreach($c as $n => $limit){
                if(substr($k, 7) == $db){
                    $array[] = [
                        'limit' => $limit,
                        'database' => $k,
                        'name' => $n
                    ];
                }
            }
        }
        return $array;
    }
}